# frozen_string_literal: true

module KDL
  module Types
    class Country < Value::Custom
      # From: https://en.wikipedia.org/wiki/ISO_3166-1#Current_codes
      COUNTRIES3 = {
        'AFG' => { alpha3: 'AFG', alpha2: 'AF', numeric_code: 4, name: 'Afghanistan' }.freeze,
        'ALA' => { alpha3: 'ALA', alpha2: 'AX', numeric_code: 248, name: 'Åland Islands' }.freeze,
        'ALB' => { alpha3: 'ALB', alpha2: 'AL', numeric_code: 8, name: 'Albania' }.freeze,
        'DZA' => { alpha3: 'DZA', alpha2: 'DZ', numeric_code: 12, name: 'Algeria' }.freeze,
        'ASM' => { alpha3: 'ASM', alpha2: 'AS', numeric_code: 16, name: 'American Samoa' }.freeze,
        'AND' => { alpha3: 'AND', alpha2: 'AD', numeric_code: 20, name: 'Andorra' }.freeze,
        'AGO' => { alpha3: 'AGO', alpha2: 'AO', numeric_code: 24, name: 'Angola' }.freeze,
        'AIA' => { alpha3: 'AIA', alpha2: 'AI', numeric_code: 660, name: 'Anguilla' }.freeze,
        'ATA' => { alpha3: 'ATA', alpha2: 'AQ', numeric_code: 10, name: 'Antarctica' }.freeze,
        'ATG' => { alpha3: 'ATG', alpha2: 'AG', numeric_code: 28, name: 'Antigua and Barbuda' }.freeze,
        'ARG' => { alpha3: 'ARG', alpha2: 'AR', numeric_code: 32, name: 'Argentina' }.freeze,
        'ARM' => { alpha3: 'ARM', alpha2: 'AM', numeric_code: 51, name: 'Armenia' }.freeze,
        'ABW' => { alpha3: 'ABW', alpha2: 'AW', numeric_code: 533, name: 'Aruba' }.freeze,
        'AUS' => { alpha3: 'AUS', alpha2: 'AU', numeric_code: 36, name: 'Australia' }.freeze,
        'AUT' => { alpha3: 'AUT', alpha2: 'AT', numeric_code: 40, name: 'Austria' }.freeze,
        'AZE' => { alpha3: 'AZE', alpha2: 'AZ', numeric_code: 31, name: 'Azerbaijan' }.freeze,
        'BHS' => { alpha3: 'BHS', alpha2: 'BS', numeric_code: 44, name: 'Bahamas' }.freeze,
        'BHR' => { alpha3: 'BHR', alpha2: 'BH', numeric_code: 48, name: 'Bahrain' }.freeze,
        'BGD' => { alpha3: 'BGD', alpha2: 'BD', numeric_code: 50, name: 'Bangladesh' }.freeze,
        'BRB' => { alpha3: 'BRB', alpha2: 'BB', numeric_code: 52, name: 'Barbados' }.freeze,
        'BLR' => { alpha3: 'BLR', alpha2: 'BY', numeric_code: 112, name: 'Belarus' }.freeze,
        'BEL' => { alpha3: 'BEL', alpha2: 'BE', numeric_code: 56, name: 'Belgium' }.freeze,
        'BLZ' => { alpha3: 'BLZ', alpha2: 'BZ', numeric_code: 84, name: 'Belize' }.freeze,
        'BEN' => { alpha3: 'BEN', alpha2: 'BJ', numeric_code: 204, name: 'Benin' }.freeze,
        'BMU' => { alpha3: 'BMU', alpha2: 'BM', numeric_code: 60, name: 'Bermuda' }.freeze,
        'BTN' => { alpha3: 'BTN', alpha2: 'BT', numeric_code: 64, name: 'Bhutan' }.freeze,
        'BOL' => { alpha3: 'BOL', alpha2: 'BO', numeric_code: 68, name: 'Bolivia (Plurinational State of)' }.freeze,
        'BES' => { alpha3: 'BES', alpha2: 'BQ', numeric_code: 535, name: 'Bonaire, Sint Eustatius and Saba[d]' }.freeze,
        'BIH' => { alpha3: 'BIH', alpha2: 'BA', numeric_code: 70, name: 'Bosnia and Herzegovina' }.freeze,
        'BWA' => { alpha3: 'BWA', alpha2: 'BW', numeric_code: 72, name: 'Botswana' }.freeze,
        'BVT' => { alpha3: 'BVT', alpha2: 'BV', numeric_code: 74, name: 'Bouvet Island' }.freeze,
        'BRA' => { alpha3: 'BRA', alpha2: 'BR', numeric_code: 76, name: 'Brazil' }.freeze,
        'IOT' => { alpha3: 'IOT', alpha2: 'IO', numeric_code: 86, name: 'British Indian Ocean Territory' }.freeze,
        'BRN' => { alpha3: 'BRN', alpha2: 'BN', numeric_code: 96, name: 'Brunei Darussalam' }.freeze,
        'BGR' => { alpha3: 'BGR', alpha2: 'BG', numeric_code: 100, name: 'Bulgaria' }.freeze,
        'BFA' => { alpha3: 'BFA', alpha2: 'BF', numeric_code: 854, name: 'Burkina Faso' }.freeze,
        'BDI' => { alpha3: 'BDI', alpha2: 'BI', numeric_code: 108, name: 'Burundi' }.freeze,
        'CPV' => { alpha3: 'CPV', alpha2: 'CV', numeric_code: 132, name: 'Cabo Verde' }.freeze,
        'KHM' => { alpha3: 'KHM', alpha2: 'KH', numeric_code: 116, name: 'Cambodia' }.freeze,
        'CMR' => { alpha3: 'CMR', alpha2: 'CM', numeric_code: 120, name: 'Cameroon' }.freeze,
        'CAN' => { alpha3: 'CAN', alpha2: 'CA', numeric_code: 124, name: 'Canada' }.freeze,
        'CYM' => { alpha3: 'CYM', alpha2: 'KY', numeric_code: 136, name: 'Cayman Islands' }.freeze,
        'CAF' => { alpha3: 'CAF', alpha2: 'CF', numeric_code: 140, name: 'Central African Republic' }.freeze,
        'TCD' => { alpha3: 'TCD', alpha2: 'TD', numeric_code: 148, name: 'Chad' }.freeze,
        'CHL' => { alpha3: 'CHL', alpha2: 'CL', numeric_code: 152, name: 'Chile' }.freeze,
        'CHN' => { alpha3: 'CHN', alpha2: 'CN', numeric_code: 156, name: 'China' }.freeze,
        'CXR' => { alpha3: 'CXR', alpha2: 'CX', numeric_code: 162, name: 'Christmas Island' }.freeze,
        'CCK' => { alpha3: 'CCK', alpha2: 'CC', numeric_code: 166, name: 'Cocos (Keeling) Islands' }.freeze,
        'COL' => { alpha3: 'COL', alpha2: 'CO', numeric_code: 170, name: 'Colombia' }.freeze,
        'COM' => { alpha3: 'COM', alpha2: 'KM', numeric_code: 174, name: 'Comoros' }.freeze,
        'COG' => { alpha3: 'COG', alpha2: 'CG', numeric_code: 178, name: 'Congo' }.freeze,
        'COD' => { alpha3: 'COD', alpha2: 'CD', numeric_code: 180, name: 'Congo, Democratic Republic of the' }.freeze,
        'COK' => { alpha3: 'COK', alpha2: 'CK', numeric_code: 184, name: 'Cook Islands' }.freeze,
        'CRI' => { alpha3: 'CRI', alpha2: 'CR', numeric_code: 188, name: 'Costa Rica' }.freeze,
        'CIV' => { alpha3: 'CIV', alpha2: 'CI', numeric_code: 384, name: 'Côte d\'Ivoire' }.freeze,
        'HRV' => { alpha3: 'HRV', alpha2: 'HR', numeric_code: 191, name: 'Croatia' }.freeze,
        'CUB' => { alpha3: 'CUB', alpha2: 'CU', numeric_code: 192, name: 'Cuba' }.freeze,
        'CUW' => { alpha3: 'CUW', alpha2: 'CW', numeric_code: 531, name: 'Curaçao' }.freeze,
        'CYP' => { alpha3: 'CYP', alpha2: 'CY', numeric_code: 196, name: 'Cyprus' }.freeze,
        'CZE' => { alpha3: 'CZE', alpha2: 'CZ', numeric_code: 203, name: 'Czechia' }.freeze,
        'DNK' => { alpha3: 'DNK', alpha2: 'DK', numeric_code: 208, name: 'Denmark' }.freeze,
        'DJI' => { alpha3: 'DJI', alpha2: 'DJ', numeric_code: 262, name: 'Djibouti' }.freeze,
        'DMA' => { alpha3: 'DMA', alpha2: 'DM', numeric_code: 212, name: 'Dominica' }.freeze,
        'DOM' => { alpha3: 'DOM', alpha2: 'DO', numeric_code: 214, name: 'Dominican Republic' }.freeze,
        'ECU' => { alpha3: 'ECU', alpha2: 'EC', numeric_code: 218, name: 'Ecuador' }.freeze,
        'EGY' => { alpha3: 'EGY', alpha2: 'EG', numeric_code: 818, name: 'Egypt' }.freeze,
        'SLV' => { alpha3: 'SLV', alpha2: 'SV', numeric_code: 222, name: 'El Salvador' }.freeze,
        'GNQ' => { alpha3: 'GNQ', alpha2: 'GQ', numeric_code: 226, name: 'Equatorial Guinea' }.freeze,
        'ERI' => { alpha3: 'ERI', alpha2: 'ER', numeric_code: 232, name: 'Eritrea' }.freeze,
        'EST' => { alpha3: 'EST', alpha2: 'EE', numeric_code: 233, name: 'Estonia' }.freeze,
        'SWZ' => { alpha3: 'SWZ', alpha2: 'SZ', numeric_code: 748, name: 'Eswatini' }.freeze,
        'ETH' => { alpha3: 'ETH', alpha2: 'ET', numeric_code: 231, name: 'Ethiopia' }.freeze,
        'FLK' => { alpha3: 'FLK', alpha2: 'FK', numeric_code: 238, name: 'Falkland Islands (Malvinas)' }.freeze,
        'FRO' => { alpha3: 'FRO', alpha2: 'FO', numeric_code: 234, name: 'Faroe Islands' }.freeze,
        'FJI' => { alpha3: 'FJI', alpha2: 'FJ', numeric_code: 242, name: 'Fiji' }.freeze,
        'FIN' => { alpha3: 'FIN', alpha2: 'FI', numeric_code: 246, name: 'Finland' }.freeze,
        'FRA' => { alpha3: 'FRA', alpha2: 'FR', numeric_code: 250, name: 'France' }.freeze,
        'GUF' => { alpha3: 'GUF', alpha2: 'GF', numeric_code: 254, name: 'French Guiana' }.freeze,
        'PYF' => { alpha3: 'PYF', alpha2: 'PF', numeric_code: 258, name: 'French Polynesia' }.freeze,
        'ATF' => { alpha3: 'ATF', alpha2: 'TF', numeric_code: 260, name: 'French Southern Territories' }.freeze,
        'GAB' => { alpha3: 'GAB', alpha2: 'GA', numeric_code: 266, name: 'Gabon' }.freeze,
        'GMB' => { alpha3: 'GMB', alpha2: 'GM', numeric_code: 270, name: 'Gambia' }.freeze,
        'GEO' => { alpha3: 'GEO', alpha2: 'GE', numeric_code: 268, name: 'Georgia' }.freeze,
        'DEU' => { alpha3: 'DEU', alpha2: 'DE', numeric_code: 276, name: 'Germany' }.freeze,
        'GHA' => { alpha3: 'GHA', alpha2: 'GH', numeric_code: 288, name: 'Ghana' }.freeze,
        'GIB' => { alpha3: 'GIB', alpha2: 'GI', numeric_code: 292, name: 'Gibraltar' }.freeze,
        'GRC' => { alpha3: 'GRC', alpha2: 'GR', numeric_code: 300, name: 'Greece' }.freeze,
        'GRL' => { alpha3: 'GRL', alpha2: 'GL', numeric_code: 304, name: 'Greenland' }.freeze,
        'GRD' => { alpha3: 'GRD', alpha2: 'GD', numeric_code: 308, name: 'Grenada' }.freeze,
        'GLP' => { alpha3: 'GLP', alpha2: 'GP', numeric_code: 312, name: 'Guadeloupe' }.freeze,
        'GUM' => { alpha3: 'GUM', alpha2: 'GU', numeric_code: 316, name: 'Guam' }.freeze,
        'GTM' => { alpha3: 'GTM', alpha2: 'GT', numeric_code: 320, name: 'Guatemala' }.freeze,
        'GGY' => { alpha3: 'GGY', alpha2: 'GG', numeric_code: 831, name: 'Guernsey' }.freeze,
        'GIN' => { alpha3: 'GIN', alpha2: 'GN', numeric_code: 324, name: 'Guinea' }.freeze,
        'GNB' => { alpha3: 'GNB', alpha2: 'GW', numeric_code: 624, name: 'Guinea-Bissau' }.freeze,
        'GUY' => { alpha3: 'GUY', alpha2: 'GY', numeric_code: 328, name: 'Guyana' }.freeze,
        'HTI' => { alpha3: 'HTI', alpha2: 'HT', numeric_code: 332, name: 'Haiti' }.freeze,
        'HMD' => { alpha3: 'HMD', alpha2: 'HM', numeric_code: 334, name: 'Heard Island and McDonald Islands' }.freeze,
        'VAT' => { alpha3: 'VAT', alpha2: 'VA', numeric_code: 336, name: 'Holy See' }.freeze,
        'HND' => { alpha3: 'HND', alpha2: 'HN', numeric_code: 340, name: 'Honduras' }.freeze,
        'HKG' => { alpha3: 'HKG', alpha2: 'HK', numeric_code: 344, name: 'Hong Kong' }.freeze,
        'HUN' => { alpha3: 'HUN', alpha2: 'HU', numeric_code: 348, name: 'Hungary' }.freeze,
        'ISL' => { alpha3: 'ISL', alpha2: 'IS', numeric_code: 352, name: 'Iceland' }.freeze,
        'IND' => { alpha3: 'IND', alpha2: 'IN', numeric_code: 356, name: 'India' }.freeze,
        'IDN' => { alpha3: 'IDN', alpha2: 'ID', numeric_code: 360, name: 'Indonesia' }.freeze,
        'IRN' => { alpha3: 'IRN', alpha2: 'IR', numeric_code: 364, name: 'Iran (Islamic Republic of)' }.freeze,
        'IRQ' => { alpha3: 'IRQ', alpha2: 'IQ', numeric_code: 368, name: 'Iraq' }.freeze,
        'IRL' => { alpha3: 'IRL', alpha2: 'IE', numeric_code: 372, name: 'Ireland' }.freeze,
        'IMN' => { alpha3: 'IMN', alpha2: 'IM', numeric_code: 833, name: 'Isle of Man' }.freeze,
        'ISR' => { alpha3: 'ISR', alpha2: 'IL', numeric_code: 376, name: 'Israel' }.freeze,
        'ITA' => { alpha3: 'ITA', alpha2: 'IT', numeric_code: 380, name: 'Italy' }.freeze,
        'JAM' => { alpha3: 'JAM', alpha2: 'JM', numeric_code: 388, name: 'Jamaica' }.freeze,
        'JPN' => { alpha3: 'JPN', alpha2: 'JP', numeric_code: 392, name: 'Japan' }.freeze,
        'JEY' => { alpha3: 'JEY', alpha2: 'JE', numeric_code: 832, name: 'Jersey' }.freeze,
        'JOR' => { alpha3: 'JOR', alpha2: 'JO', numeric_code: 400, name: 'Jordan' }.freeze,
        'KAZ' => { alpha3: 'KAZ', alpha2: 'KZ', numeric_code: 398, name: 'Kazakhstan' }.freeze,
        'KEN' => { alpha3: 'KEN', alpha2: 'KE', numeric_code: 404, name: 'Kenya' }.freeze,
        'KIR' => { alpha3: 'KIR', alpha2: 'KI', numeric_code: 296, name: 'Kiribati' }.freeze,
        'PRK' => { alpha3: 'PRK', alpha2: 'KP', numeric_code: 408, name: 'Korea (Democratic People\'s Republic of)' }.freeze,
        'KOR' => { alpha3: 'KOR', alpha2: 'KR', numeric_code: 410, name: 'Korea, Republic of' }.freeze,
        'KWT' => { alpha3: 'KWT', alpha2: 'KW', numeric_code: 414, name: 'Kuwait' }.freeze,
        'KGZ' => { alpha3: 'KGZ', alpha2: 'KG', numeric_code: 417, name: 'Kyrgyzstan' }.freeze,
        'LAO' => { alpha3: 'LAO', alpha2: 'LA', numeric_code: 418, name: 'Lao People\'s Democratic Republic' }.freeze,
        'LVA' => { alpha3: 'LVA', alpha2: 'LV', numeric_code: 428, name: 'Latvia' }.freeze,
        'LBN' => { alpha3: 'LBN', alpha2: 'LB', numeric_code: 422, name: 'Lebanon' }.freeze,
        'LSO' => { alpha3: 'LSO', alpha2: 'LS', numeric_code: 426, name: 'Lesotho' }.freeze,
        'LBR' => { alpha3: 'LBR', alpha2: 'LR', numeric_code: 430, name: 'Liberia' }.freeze,
        'LBY' => { alpha3: 'LBY', alpha2: 'LY', numeric_code: 434, name: 'Libya' }.freeze,
        'LIE' => { alpha3: 'LIE', alpha2: 'LI', numeric_code: 438, name: 'Liechtenstein' }.freeze,
        'LTU' => { alpha3: 'LTU', alpha2: 'LT', numeric_code: 440, name: 'Lithuania' }.freeze,
        'LUX' => { alpha3: 'LUX', alpha2: 'LU', numeric_code: 442, name: 'Luxembourg' }.freeze,
        'MAC' => { alpha3: 'MAC', alpha2: 'MO', numeric_code: 446, name: 'Macao' }.freeze,
        'MDG' => { alpha3: 'MDG', alpha2: 'MG', numeric_code: 450, name: 'Madagascar' }.freeze,
        'MWI' => { alpha3: 'MWI', alpha2: 'MW', numeric_code: 454, name: 'Malawi' }.freeze,
        'MYS' => { alpha3: 'MYS', alpha2: 'MY', numeric_code: 458, name: 'Malaysia' }.freeze,
        'MDV' => { alpha3: 'MDV', alpha2: 'MV', numeric_code: 462, name: 'Maldives' }.freeze,
        'MLI' => { alpha3: 'MLI', alpha2: 'ML', numeric_code: 466, name: 'Mali' }.freeze,
        'MLT' => { alpha3: 'MLT', alpha2: 'MT', numeric_code: 470, name: 'Malta' }.freeze,
        'MHL' => { alpha3: 'MHL', alpha2: 'MH', numeric_code: 584, name: 'Marshall Islands' }.freeze,
        'MTQ' => { alpha3: 'MTQ', alpha2: 'MQ', numeric_code: 474, name: 'Martinique' }.freeze,
        'MRT' => { alpha3: 'MRT', alpha2: 'MR', numeric_code: 478, name: 'Mauritania' }.freeze,
        'MUS' => { alpha3: 'MUS', alpha2: 'MU', numeric_code: 480, name: 'Mauritius' }.freeze,
        'MYT' => { alpha3: 'MYT', alpha2: 'YT', numeric_code: 175, name: 'Mayotte' }.freeze,
        'MEX' => { alpha3: 'MEX', alpha2: 'MX', numeric_code: 484, name: 'Mexico' }.freeze,
        'FSM' => { alpha3: 'FSM', alpha2: 'FM', numeric_code: 583, name: 'Micronesia (Federated States of)' }.freeze,
        'MDA' => { alpha3: 'MDA', alpha2: 'MD', numeric_code: 498, name: 'Moldova, Republic of' }.freeze,
        'MCO' => { alpha3: 'MCO', alpha2: 'MC', numeric_code: 492, name: 'Monaco' }.freeze,
        'MNG' => { alpha3: 'MNG', alpha2: 'MN', numeric_code: 496, name: 'Mongolia' }.freeze,
        'MNE' => { alpha3: 'MNE', alpha2: 'ME', numeric_code: 499, name: 'Montenegro' }.freeze,
        'MSR' => { alpha3: 'MSR', alpha2: 'MS', numeric_code: 500, name: 'Montserrat' }.freeze,
        'MAR' => { alpha3: 'MAR', alpha2: 'MA', numeric_code: 504, name: 'Morocco' }.freeze,
        'MOZ' => { alpha3: 'MOZ', alpha2: 'MZ', numeric_code: 508, name: 'Mozambique' }.freeze,
        'MMR' => { alpha3: 'MMR', alpha2: 'MM', numeric_code: 104, name: 'Myanmar' }.freeze,
        'NAM' => { alpha3: 'NAM', alpha2: 'NA', numeric_code: 516, name: 'Namibia' }.freeze,
        'NRU' => { alpha3: 'NRU', alpha2: 'NR', numeric_code: 520, name: 'Nauru' }.freeze,
        'NPL' => { alpha3: 'NPL', alpha2: 'NP', numeric_code: 524, name: 'Nepal' }.freeze,
        'NLD' => { alpha3: 'NLD', alpha2: 'NL', numeric_code: 528, name: 'Netherlands' }.freeze,
        'NCL' => { alpha3: 'NCL', alpha2: 'NC', numeric_code: 540, name: 'New Caledonia' }.freeze,
        'NZL' => { alpha3: 'NZL', alpha2: 'NZ', numeric_code: 554, name: 'New Zealand' }.freeze,
        'NIC' => { alpha3: 'NIC', alpha2: 'NI', numeric_code: 558, name: 'Nicaragua' }.freeze,
        'NER' => { alpha3: 'NER', alpha2: 'NE', numeric_code: 562, name: 'Niger' }.freeze,
        'NGA' => { alpha3: 'NGA', alpha2: 'NG', numeric_code: 566, name: 'Nigeria' }.freeze,
        'NIU' => { alpha3: 'NIU', alpha2: 'NU', numeric_code: 570, name: 'Niue' }.freeze,
        'NFK' => { alpha3: 'NFK', alpha2: 'NF', numeric_code: 574, name: 'Norfolk Island' }.freeze,
        'MKD' => { alpha3: 'MKD', alpha2: 'MK', numeric_code: 807, name: 'North Macedonia' }.freeze,
        'MNP' => { alpha3: 'MNP', alpha2: 'MP', numeric_code: 580, name: 'Northern Mariana Islands' }.freeze,
        'NOR' => { alpha3: 'NOR', alpha2: 'NO', numeric_code: 578, name: 'Norway' }.freeze,
        'OMN' => { alpha3: 'OMN', alpha2: 'OM', numeric_code: 512, name: 'Oman' }.freeze,
        'PAK' => { alpha3: 'PAK', alpha2: 'PK', numeric_code: 586, name: 'Pakistan' }.freeze,
        'PLW' => { alpha3: 'PLW', alpha2: 'PW', numeric_code: 585, name: 'Palau' }.freeze,
        'PSE' => { alpha3: 'PSE', alpha2: 'PS', numeric_code: 275, name: 'Palestine, State of' }.freeze,
        'PAN' => { alpha3: 'PAN', alpha2: 'PA', numeric_code: 591, name: 'Panama' }.freeze,
        'PNG' => { alpha3: 'PNG', alpha2: 'PG', numeric_code: 598, name: 'Papua New Guinea' }.freeze,
        'PRY' => { alpha3: 'PRY', alpha2: 'PY', numeric_code: 600, name: 'Paraguay' }.freeze,
        'PER' => { alpha3: 'PER', alpha2: 'PE', numeric_code: 604, name: 'Peru' }.freeze,
        'PHL' => { alpha3: 'PHL', alpha2: 'PH', numeric_code: 608, name: 'Philippines' }.freeze,
        'PCN' => { alpha3: 'PCN', alpha2: 'PN', numeric_code: 612, name: 'Pitcairn' }.freeze,
        'POL' => { alpha3: 'POL', alpha2: 'PL', numeric_code: 616, name: 'Poland' }.freeze,
        'PRT' => { alpha3: 'PRT', alpha2: 'PT', numeric_code: 620, name: 'Portugal' }.freeze,
        'PRI' => { alpha3: 'PRI', alpha2: 'PR', numeric_code: 630, name: 'Puerto Rico' }.freeze,
        'QAT' => { alpha3: 'QAT', alpha2: 'QA', numeric_code: 634, name: 'Qatar' }.freeze,
        'REU' => { alpha3: 'REU', alpha2: 'RE', numeric_code: 638, name: 'Réunion' }.freeze,
        'ROU' => { alpha3: 'ROU', alpha2: 'RO', numeric_code: 642, name: 'Romania' }.freeze,
        'RUS' => { alpha3: 'RUS', alpha2: 'RU', numeric_code: 643, name: 'Russian Federation' }.freeze,
        'RWA' => { alpha3: 'RWA', alpha2: 'RW', numeric_code: 646, name: 'Rwanda' }.freeze,
        'BLM' => { alpha3: 'BLM', alpha2: 'BL', numeric_code: 652, name: 'Saint Barthélemy' }.freeze,
        'SHN' => { alpha3: 'SHN', alpha2: 'SH', numeric_code: 654, name: 'Saint Helena, Ascension and Tristan da Cunha[e]' }.freeze,
        'KNA' => { alpha3: 'KNA', alpha2: 'KN', numeric_code: 659, name: 'Saint Kitts and Nevis' }.freeze,
        'LCA' => { alpha3: 'LCA', alpha2: 'LC', numeric_code: 662, name: 'Saint Lucia' }.freeze,
        'MAF' => { alpha3: 'MAF', alpha2: 'MF', numeric_code: 663, name: 'Saint Martin (French part)' }.freeze,
        'SPM' => { alpha3: 'SPM', alpha2: 'PM', numeric_code: 666, name: 'Saint Pierre and Miquelon' }.freeze,
        'VCT' => { alpha3: 'VCT', alpha2: 'VC', numeric_code: 670, name: 'Saint Vincent and the Grenadines' }.freeze,
        'WSM' => { alpha3: 'WSM', alpha2: 'WS', numeric_code: 882, name: 'Samoa' }.freeze,
        'SMR' => { alpha3: 'SMR', alpha2: 'SM', numeric_code: 674, name: 'San Marino' }.freeze,
        'STP' => { alpha3: 'STP', alpha2: 'ST', numeric_code: 678, name: 'Sao Tome and Principe' }.freeze,
        'SAU' => { alpha3: 'SAU', alpha2: 'SA', numeric_code: 682, name: 'Saudi Arabia' }.freeze,
        'SEN' => { alpha3: 'SEN', alpha2: 'SN', numeric_code: 686, name: 'Senegal' }.freeze,
        'SRB' => { alpha3: 'SRB', alpha2: 'RS', numeric_code: 688, name: 'Serbia' }.freeze,
        'SYC' => { alpha3: 'SYC', alpha2: 'SC', numeric_code: 690, name: 'Seychelles' }.freeze,
        'SLE' => { alpha3: 'SLE', alpha2: 'SL', numeric_code: 694, name: 'Sierra Leone' }.freeze,
        'SGP' => { alpha3: 'SGP', alpha2: 'SG', numeric_code: 702, name: 'Singapore' }.freeze,
        'SXM' => { alpha3: 'SXM', alpha2: 'SX', numeric_code: 534, name: 'Sint Maarten (Dutch part)' }.freeze,
        'SVK' => { alpha3: 'SVK', alpha2: 'SK', numeric_code: 703, name: 'Slovakia' }.freeze,
        'SVN' => { alpha3: 'SVN', alpha2: 'SI', numeric_code: 705, name: 'Slovenia' }.freeze,
        'SLB' => { alpha3: 'SLB', alpha2: 'SB', numeric_code: 90, name: 'Solomon Islands' }.freeze,
        'SOM' => { alpha3: 'SOM', alpha2: 'SO', numeric_code: 706, name: 'Somalia' }.freeze,
        'ZAF' => { alpha3: 'ZAF', alpha2: 'ZA', numeric_code: 710, name: 'South Africa' }.freeze,
        'SGS' => { alpha3: 'SGS', alpha2: 'GS', numeric_code: 239, name: 'South Georgia and the South Sandwich Islands' }.freeze,
        'SSD' => { alpha3: 'SSD', alpha2: 'SS', numeric_code: 728, name: 'South Sudan' }.freeze,
        'ESP' => { alpha3: 'ESP', alpha2: 'ES', numeric_code: 724, name: 'Spain' }.freeze,
        'LKA' => { alpha3: 'LKA', alpha2: 'LK', numeric_code: 144, name: 'Sri Lanka' }.freeze,
        'SDN' => { alpha3: 'SDN', alpha2: 'SD', numeric_code: 729, name: 'Sudan' }.freeze,
        'SUR' => { alpha3: 'SUR', alpha2: 'SR', numeric_code: 740, name: 'Suriname' }.freeze,
        'SJM' => { alpha3: 'SJM', alpha2: 'SJ', numeric_code: 744, name: 'Svalbard and Jan Mayen[f]' }.freeze,
        'SWE' => { alpha3: 'SWE', alpha2: 'SE', numeric_code: 752, name: 'Sweden' }.freeze,
        'CHE' => { alpha3: 'CHE', alpha2: 'CH', numeric_code: 756, name: 'Switzerland' }.freeze,
        'SYR' => { alpha3: 'SYR', alpha2: 'SY', numeric_code: 760, name: 'Syrian Arab Republic' }.freeze,
        'TWN' => { alpha3: 'TWN', alpha2: 'TW', numeric_code: 158, name: 'Taiwan, Province of China' }.freeze,
        'TJK' => { alpha3: 'TJK', alpha2: 'TJ', numeric_code: 762, name: 'Tajikistan' }.freeze,
        'TZA' => { alpha3: 'TZA', alpha2: 'TZ', numeric_code: 834, name: 'Tanzania, United Republic of' }.freeze,
        'THA' => { alpha3: 'THA', alpha2: 'TH', numeric_code: 764, name: 'Thailand' }.freeze,
        'TLS' => { alpha3: 'TLS', alpha2: 'TL', numeric_code: 626, name: 'Timor-Leste' }.freeze,
        'TGO' => { alpha3: 'TGO', alpha2: 'TG', numeric_code: 768, name: 'Togo' }.freeze,
        'TKL' => { alpha3: 'TKL', alpha2: 'TK', numeric_code: 772, name: 'Tokelau' }.freeze,
        'TON' => { alpha3: 'TON', alpha2: 'TO', numeric_code: 776, name: 'Tonga' }.freeze,
        'TTO' => { alpha3: 'TTO', alpha2: 'TT', numeric_code: 780, name: 'Trinidad and Tobago' }.freeze,
        'TUN' => { alpha3: 'TUN', alpha2: 'TN', numeric_code: 788, name: 'Tunisia' }.freeze,
        'TUR' => { alpha3: 'TUR', alpha2: 'TR', numeric_code: 792, name: 'Turkey' }.freeze,
        'TKM' => { alpha3: 'TKM', alpha2: 'TM', numeric_code: 795, name: 'Turkmenistan' }.freeze,
        'TCA' => { alpha3: 'TCA', alpha2: 'TC', numeric_code: 796, name: 'Turks and Caicos Islands' }.freeze,
        'TUV' => { alpha3: 'TUV', alpha2: 'TV', numeric_code: 798, name: 'Tuvalu' }.freeze,
        'UGA' => { alpha3: 'UGA', alpha2: 'UG', numeric_code: 800, name: 'Uganda' }.freeze,
        'UKR' => { alpha3: 'UKR', alpha2: 'UA', numeric_code: 804, name: 'Ukraine' }.freeze,
        'ARE' => { alpha3: 'ARE', alpha2: 'AE', numeric_code: 784, name: 'United Arab Emirates' }.freeze,
        'GBR' => { alpha3: 'GBR', alpha2: 'GB', numeric_code: 826, name: 'United Kingdom of Great Britain and Northern Ireland' }.freeze,
        'USA' => { alpha3: 'USA', alpha2: 'US', numeric_code: 840, name: 'United States of America' }.freeze,
        'UMI' => { alpha3: 'UMI', alpha2: 'UM', numeric_code: 581, name: 'United States Minor Outlying Islands[h]' }.freeze,
        'URY' => { alpha3: 'URY', alpha2: 'UY', numeric_code: 858, name: 'Uruguay' }.freeze,
        'UZB' => { alpha3: 'UZB', alpha2: 'UZ', numeric_code: 860, name: 'Uzbekistan' }.freeze,
        'VUT' => { alpha3: 'VUT', alpha2: 'VU', numeric_code: 548, name: 'Vanuatu' }.freeze,
        'VEN' => { alpha3: 'VEN', alpha2: 'VE', numeric_code: 862, name: 'Venezuela (Bolivarian Republic of)' }.freeze,
        'VNM' => { alpha3: 'VNM', alpha2: 'VN', numeric_code: 704, name: 'Viet Nam' }.freeze,
        'VGB' => { alpha3: 'VGB', alpha2: 'VG', numeric_code: 92, name: 'Virgin Islands (British)' }.freeze,
        'VIR' => { alpha3: 'VIR', alpha2: 'VI', numeric_code: 850, name: 'Virgin Islands (U.S.)' }.freeze,
        'WLF' => { alpha3: 'WLF', alpha2: 'WF', numeric_code: 876, name: 'Wallis and Futuna' }.freeze,
        'ESH' => { alpha3: 'ESH', alpha2: 'EH', numeric_code: 732, name: 'Western Sahara' }.freeze,
        'YEM' => { alpha3: 'YEM', alpha2: 'YE', numeric_code: 887, name: 'Yemen' }.freeze,
        'ZMB' => { alpha3: 'ZMB', alpha2: 'ZM', numeric_code: 894, name: 'Zambia' }.freeze,
        'ZWE' => { alpha3: 'ZWE', alpha2: 'ZW', numeric_code: 716, name: 'Zimbabwe' }.freeze
      }.freeze

      COUNTRIES2 = {
        'AF' => COUNTRIES3['AFG'],
        'AX' => COUNTRIES3['ALA'],
        'AL' => COUNTRIES3['ALB'],
        'DZ' => COUNTRIES3['DZA'],
        'AS' => COUNTRIES3['ASM'],
        'AD' => COUNTRIES3['AND'],
        'AO' => COUNTRIES3['AGO'],
        'AI' => COUNTRIES3['AIA'],
        'AQ' => COUNTRIES3['ATA'],
        'AG' => COUNTRIES3['ATG'],
        'AR' => COUNTRIES3['ARG'],
        'AM' => COUNTRIES3['ARM'],
        'AW' => COUNTRIES3['ABW'],
        'AU' => COUNTRIES3['AUS'],
        'AT' => COUNTRIES3['AUT'],
        'AZ' => COUNTRIES3['AZE'],
        'BS' => COUNTRIES3['BHS'],
        'BH' => COUNTRIES3['BHR'],
        'BD' => COUNTRIES3['BGD'],
        'BB' => COUNTRIES3['BRB'],
        'BY' => COUNTRIES3['BLR'],
        'BE' => COUNTRIES3['BEL'],
        'BZ' => COUNTRIES3['BLZ'],
        'BJ' => COUNTRIES3['BEN'],
        'BM' => COUNTRIES3['BMU'],
        'BT' => COUNTRIES3['BTN'],
        'BO' => COUNTRIES3['BOL'],
        'BQ' => COUNTRIES3['BES'],
        'BA' => COUNTRIES3['BIH'],
        'BW' => COUNTRIES3['BWA'],
        'BV' => COUNTRIES3['BVT'],
        'BR' => COUNTRIES3['BRA'],
        'IO' => COUNTRIES3['IOT'],
        'BN' => COUNTRIES3['BRN'],
        'BG' => COUNTRIES3['BGR'],
        'BF' => COUNTRIES3['BFA'],
        'BI' => COUNTRIES3['BDI'],
        'CV' => COUNTRIES3['CPV'],
        'KH' => COUNTRIES3['KHM'],
        'CM' => COUNTRIES3['CMR'],
        'CA' => COUNTRIES3['CAN'],
        'KY' => COUNTRIES3['CYM'],
        'CF' => COUNTRIES3['CAF'],
        'TD' => COUNTRIES3['TCD'],
        'CL' => COUNTRIES3['CHL'],
        'CN' => COUNTRIES3['CHN'],
        'CX' => COUNTRIES3['CXR'],
        'CC' => COUNTRIES3['CCK'],
        'CO' => COUNTRIES3['COL'],
        'KM' => COUNTRIES3['COM'],
        'CG' => COUNTRIES3['COG'],
        'CD' => COUNTRIES3['COD'],
        'CK' => COUNTRIES3['COK'],
        'CR' => COUNTRIES3['CRI'],
        'CI' => COUNTRIES3['CIV'],
        'HR' => COUNTRIES3['HRV'],
        'CU' => COUNTRIES3['CUB'],
        'CW' => COUNTRIES3['CUW'],
        'CY' => COUNTRIES3['CYP'],
        'CZ' => COUNTRIES3['CZE'],
        'DK' => COUNTRIES3['DNK'],
        'DJ' => COUNTRIES3['DJI'],
        'DM' => COUNTRIES3['DMA'],
        'DO' => COUNTRIES3['DOM'],
        'EC' => COUNTRIES3['ECU'],
        'EG' => COUNTRIES3['EGY'],
        'SV' => COUNTRIES3['SLV'],
        'GQ' => COUNTRIES3['GNQ'],
        'ER' => COUNTRIES3['ERI'],
        'EE' => COUNTRIES3['EST'],
        'SZ' => COUNTRIES3['SWZ'],
        'ET' => COUNTRIES3['ETH'],
        'FK' => COUNTRIES3['FLK'],
        'FO' => COUNTRIES3['FRO'],
        'FJ' => COUNTRIES3['FJI'],
        'FI' => COUNTRIES3['FIN'],
        'FR' => COUNTRIES3['FRA'],
        'GF' => COUNTRIES3['GUF'],
        'PF' => COUNTRIES3['PYF'],
        'TF' => COUNTRIES3['ATF'],
        'GA' => COUNTRIES3['GAB'],
        'GM' => COUNTRIES3['GMB'],
        'GE' => COUNTRIES3['GEO'],
        'DE' => COUNTRIES3['DEU'],
        'GH' => COUNTRIES3['GHA'],
        'GI' => COUNTRIES3['GIB'],
        'GR' => COUNTRIES3['GRC'],
        'GL' => COUNTRIES3['GRL'],
        'GD' => COUNTRIES3['GRD'],
        'GP' => COUNTRIES3['GLP'],
        'GU' => COUNTRIES3['GUM'],
        'GT' => COUNTRIES3['GTM'],
        'GG' => COUNTRIES3['GGY'],
        'GN' => COUNTRIES3['GIN'],
        'GW' => COUNTRIES3['GNB'],
        'GY' => COUNTRIES3['GUY'],
        'HT' => COUNTRIES3['HTI'],
        'HM' => COUNTRIES3['HMD'],
        'VA' => COUNTRIES3['VAT'],
        'HN' => COUNTRIES3['HND'],
        'HK' => COUNTRIES3['HKG'],
        'HU' => COUNTRIES3['HUN'],
        'IS' => COUNTRIES3['ISL'],
        'IN' => COUNTRIES3['IND'],
        'ID' => COUNTRIES3['IDN'],
        'IR' => COUNTRIES3['IRN'],
        'IQ' => COUNTRIES3['IRQ'],
        'IE' => COUNTRIES3['IRL'],
        'IM' => COUNTRIES3['IMN'],
        'IL' => COUNTRIES3['ISR'],
        'IT' => COUNTRIES3['ITA'],
        'JM' => COUNTRIES3['JAM'],
        'JP' => COUNTRIES3['JPN'],
        'JE' => COUNTRIES3['JEY'],
        'JO' => COUNTRIES3['JOR'],
        'KZ' => COUNTRIES3['KAZ'],
        'KE' => COUNTRIES3['KEN'],
        'KI' => COUNTRIES3['KIR'],
        'KP' => COUNTRIES3['PRK'],
        'KR' => COUNTRIES3['KOR'],
        'KW' => COUNTRIES3['KWT'],
        'KG' => COUNTRIES3['KGZ'],
        'LA' => COUNTRIES3['LAO'],
        'LV' => COUNTRIES3['LVA'],
        'LB' => COUNTRIES3['LBN'],
        'LS' => COUNTRIES3['LSO'],
        'LR' => COUNTRIES3['LBR'],
        'LY' => COUNTRIES3['LBY'],
        'LI' => COUNTRIES3['LIE'],
        'LT' => COUNTRIES3['LTU'],
        'LU' => COUNTRIES3['LUX'],
        'MO' => COUNTRIES3['MAC'],
        'MG' => COUNTRIES3['MDG'],
        'MW' => COUNTRIES3['MWI'],
        'MY' => COUNTRIES3['MYS'],
        'MV' => COUNTRIES3['MDV'],
        'ML' => COUNTRIES3['MLI'],
        'MT' => COUNTRIES3['MLT'],
        'MH' => COUNTRIES3['MHL'],
        'MQ' => COUNTRIES3['MTQ'],
        'MR' => COUNTRIES3['MRT'],
        'MU' => COUNTRIES3['MUS'],
        'YT' => COUNTRIES3['MYT'],
        'MX' => COUNTRIES3['MEX'],
        'FM' => COUNTRIES3['FSM'],
        'MD' => COUNTRIES3['MDA'],
        'MC' => COUNTRIES3['MCO'],
        'MN' => COUNTRIES3['MNG'],
        'ME' => COUNTRIES3['MNE'],
        'MS' => COUNTRIES3['MSR'],
        'MA' => COUNTRIES3['MAR'],
        'MZ' => COUNTRIES3['MOZ'],
        'MM' => COUNTRIES3['MMR'],
        'NA' => COUNTRIES3['NAM'],
        'NR' => COUNTRIES3['NRU'],
        'NP' => COUNTRIES3['NPL'],
        'NL' => COUNTRIES3['NLD'],
        'NC' => COUNTRIES3['NCL'],
        'NZ' => COUNTRIES3['NZL'],
        'NI' => COUNTRIES3['NIC'],
        'NE' => COUNTRIES3['NER'],
        'NG' => COUNTRIES3['NGA'],
        'NU' => COUNTRIES3['NIU'],
        'NF' => COUNTRIES3['NFK'],
        'MK' => COUNTRIES3['MKD'],
        'MP' => COUNTRIES3['MNP'],
        'NO' => COUNTRIES3['NOR'],
        'OM' => COUNTRIES3['OMN'],
        'PK' => COUNTRIES3['PAK'],
        'PW' => COUNTRIES3['PLW'],
        'PS' => COUNTRIES3['PSE'],
        'PA' => COUNTRIES3['PAN'],
        'PG' => COUNTRIES3['PNG'],
        'PY' => COUNTRIES3['PRY'],
        'PE' => COUNTRIES3['PER'],
        'PH' => COUNTRIES3['PHL'],
        'PN' => COUNTRIES3['PCN'],
        'PL' => COUNTRIES3['POL'],
        'PT' => COUNTRIES3['PRT'],
        'PR' => COUNTRIES3['PRI'],
        'QA' => COUNTRIES3['QAT'],
        'RE' => COUNTRIES3['REU'],
        'RO' => COUNTRIES3['ROU'],
        'RU' => COUNTRIES3['RUS'],
        'RW' => COUNTRIES3['RWA'],
        'BL' => COUNTRIES3['BLM'],
        'SH' => COUNTRIES3['SHN'],
        'KN' => COUNTRIES3['KNA'],
        'LC' => COUNTRIES3['LCA'],
        'MF' => COUNTRIES3['MAF'],
        'PM' => COUNTRIES3['SPM'],
        'VC' => COUNTRIES3['VCT'],
        'WS' => COUNTRIES3['WSM'],
        'SM' => COUNTRIES3['SMR'],
        'ST' => COUNTRIES3['STP'],
        'SA' => COUNTRIES3['SAU'],
        'SN' => COUNTRIES3['SEN'],
        'RS' => COUNTRIES3['SRB'],
        'SC' => COUNTRIES3['SYC'],
        'SL' => COUNTRIES3['SLE'],
        'SG' => COUNTRIES3['SGP'],
        'SX' => COUNTRIES3['SXM'],
        'SK' => COUNTRIES3['SVK'],
        'SI' => COUNTRIES3['SVN'],
        'SB' => COUNTRIES3['SLB'],
        'SO' => COUNTRIES3['SOM'],
        'ZA' => COUNTRIES3['ZAF'],
        'GS' => COUNTRIES3['SGS'],
        'SS' => COUNTRIES3['SSD'],
        'ES' => COUNTRIES3['ESP'],
        'LK' => COUNTRIES3['LKA'],
        'SD' => COUNTRIES3['SDN'],
        'SR' => COUNTRIES3['SUR'],
        'SJ' => COUNTRIES3['SJM'],
        'SE' => COUNTRIES3['SWE'],
        'CH' => COUNTRIES3['CHE'],
        'SY' => COUNTRIES3['SYR'],
        'TW' => COUNTRIES3['TWN'],
        'TJ' => COUNTRIES3['TJK'],
        'TZ' => COUNTRIES3['TZA'],
        'TH' => COUNTRIES3['THA'],
        'TL' => COUNTRIES3['TLS'],
        'TG' => COUNTRIES3['TGO'],
        'TK' => COUNTRIES3['TKL'],
        'TO' => COUNTRIES3['TON'],
        'TT' => COUNTRIES3['TTO'],
        'TN' => COUNTRIES3['TUN'],
        'TR' => COUNTRIES3['TUR'],
        'TM' => COUNTRIES3['TKM'],
        'TC' => COUNTRIES3['TCA'],
        'TV' => COUNTRIES3['TUV'],
        'UG' => COUNTRIES3['UGA'],
        'UA' => COUNTRIES3['UKR'],
        'AE' => COUNTRIES3['ARE'],
        'GB' => COUNTRIES3['GBR'],
        'US' => COUNTRIES3['USA'],
        'UM' => COUNTRIES3['UMI'],
        'UY' => COUNTRIES3['URY'],
        'UZ' => COUNTRIES3['UZB'],
        'VU' => COUNTRIES3['VUT'],
        'VE' => COUNTRIES3['VEN'],
        'VN' => COUNTRIES3['VNM'],
        'VG' => COUNTRIES3['VGB'],
        'VI' => COUNTRIES3['VIR'],
        'WF' => COUNTRIES3['WLF'],
        'EH' => COUNTRIES3['ESH'],
        'YE' => COUNTRIES3['YEM'],
        'ZM' => COUNTRIES3['ZMB'],
        'ZW' => COUNTRIES3['ZWE']
      }.freeze

      # TODO: iso3166-2 subdivision codes??
    end
  end
end
