# Changelog

## 2.0.2 (2026-02-17)
* Fix bin/ruby-prof passing printer options as positional arguments instead of keyword arguments

## 2.0.1 (2026-02-16)
* Convert bin/ruby-prof endings from CRLF to LF

## 2.0.0 (2026-02-13)
### Features
* Ruby 4.0 support.
* Add flame graph visualizations with icicle mode toggle
* Lots of documentation updates!
* Apply consistent styling across all reports
* Add `Profile#measure_mode_name` method for human-friendly measurement mode names (e.g., "Wall Time" instead of "wall_time")
* Fix DotPrinter generating self-referencing edges (was using callers instead of callees)
* Add Graphviz Online viewer link for dot output

### Backwards Incompatible Changes
* Removed `RubyProf::MEMORY` measurement mode (no longer works on Ruby 4.0+)
* Rremove compatibility API that was scheduled for removal in 2023
* Printer options now use keyword arguments instead of an options hash. For example:
  ```ruby
  # Before:
  printer.print(STDOUT, :min_percent => 2, :sort_method => :self_time)
  # After:
  printer.print(STDOUT, min_percent: 2, sort_method: :self_time)
  ```

## 1.7.2 (2025-05-21)
* Fix compiling on Ubuntu and Arch Linux
* Update tests for Ruby 3.4
* Remove tests for Ruby 3.1
* Update MacOS to use clock_gettime (same as Linux) instead of proprietary mach_absolute_time API
* Add CMake support

## 1.7.1 (2024-10-19)
* Fix crashes when calling merge due to inconsistent method keys (Chris Heald)

## 1.7.0 (2024-01-07)
* Add support for ruby 3.3.*  (Charlie Savage)
* Remove support for ruby 2.7.*  (Charlie Savage)
* Fix crash caused by referencing Profile Ruby objects from Method objects that were being moved
  by GC compaction (Charlie Savage)

## 1.6.3 (2023-04-20)
* Remove debug code unintentionally left in ruby-prof command line program (Charlie Savage)

## 1.6.2 (2023-04-17)
* Fix Profile#merge! implementation (asksurya)
* Fix ruby-prof command line program (Charlie Savage)
* Added CMakeLists.txt file (Charlie Savage)

## 1.6.1 (2023-02-21)
* Fix loading C extension for MacOS (Charlie Savage)

## 1.6.0 (2023-02-20)
* Add support for Ruby's compacting garbage collector (Charlie Savage)
* Add rbs signature files (Charlie Savage)
* Update rack adapter used for profiling Rails to include latest ruby-prof features (Charlie Savage)
* Add warnings for deprecated methods (Charlie Savage)
* Update tests to not use deprecated methods (Charlie Savage)
* Improve tests on OSX (Charlie Savage)

## 1.5.0 (2023-02-06)
* Add new Profile#merge! method that merges results for threads/fibers that share the same root method (Charlie Savage)
* Expand API to allow creation of +Measurement+, +CallTree+, +MethodInfo+ and +Thread+ instances. This
 was done to make is possible to write tests for the new Profile#merge! functionality (Charlie Savage)

## 1.4.5 (2022-12-27)
* Look for ruby_prof extension built on install in the lib directory (Charlie Savage)
* Added Ruby 3.2.0 build for mingw-urct

## 1.4.4 (2022-12-11)
* Update tests for Ruby 3.1 (Charlie Savage)
* When tracing allocations always use the RUBY_INTERNAL_EVENT_NEWOBJ trace event. Previously GC stats could also be used, but that includes the creation of internal T_IMEMO objects makes reviewing results confusing (Charlie Savage)
* Remove :profile option that lets a user set the prefix on callgrind output files since KCacheGrind will not automatically show these files in its open dialog. Fixes #313. (Charlie Savage)
* Don't expose threads to Ruby that don't have a call tree. This can happen when a user is profiling memory usage and then sends a signint to the profiled process. New objects will be created in a new thread, but no method enter/exit trace events are generated by Ruby. Thus the thread has no call tree. Fixes #312 (Charlie Savage)
* Update github Actions - change 3.0 to '3.0', add Windows mswin (MSP-Greg)
* Add Ruby 3.1 to test matrix (Charlie Savage)
* Use normal weight text instead of bold in call strack printer output. Fixes #297 (Charlie Savage)
* Update VC project to Ruby 3.1 and Visual Studio 2022 (Charlie Savage)
* Fix marshaling of profile measure. Fixes #315 (Charlie Savage)
* CI: Omit duplicate 'bundle install'. PR #309 (Olle Jonsson)
* Fix typo. s/perecent/percent/ (Paarth Madan)
* Remove support for Ruby 2.5 and 2.6 which are now end of life (Charlie Savage)

## 1.4.3 (2021-02-16)
* Remove trailing spaces (sergioro)
* Load "ruby-prof.so" with require_relative (sergioro)
* Use same file permissions for all test files (sergioro)
* Create tmp directory for test output (sergioro)
* Update git-ignore to add mkmf log (sergioro)
* Fix minitest warning about using MT_CPU instead of N (sergioro)
* Fix minitest warning "Use assert_nil if expecting nil (sergioro)
* Add xcode project (Charlie Savage)
* Update test for Ruby 3.0 (Charlie Savage)
* Remove Ruby 2.4 support since it is no longer maintained (Charlie Savage)
* Replace travis status badge with github status badge (Charlie Savage)

## 1.4.2 (2020-11-3)
* Do NOT use Ruby 2.7.0 and 2.7.1 with ruby-prof. A bug in those versions of ruby causes ruby-prof to
not work. Version 2.7.2 works correctly.
* Fix crash caused be reallocating an internal stack that keeps tracks of frames *after* getting a reference to the
top frame in the stack (Charlie Savage).
* Fix bug where the flat printer did not correctly report the correct measurement mode.

## 1.4.1 (2020-05-14)
* Fix compiling on older versions of gcc that do not default to c99 (Charlie Savage)

## 1.4.0 (2020-05-12)
* API change - remove merge_fibers support since it resulted in incorrect results or crashes (Charlie Savage)
* Fix crash when profiling memory usage (Charlie Savage)
* When tracing execution correctly print out newobj tracepoint events (Charlie Savage)
* Remove no longer needed code for building extensions (Charlie Savage)

## 1.3.2 (2020-04-19)
* Fix rack profiler so it is thread safe (Charlie Savage)
* Fix loading of prebuilt binaries on mingw64 to use Ruby's major and minor version (Charlie Savage)

## 1.3.1 (2020-03-11)
* Add max_percent and filter_by options to flat printer (Sean McGivern)
* Include binary in mingw64 build (Charlie Savage)

## 1.3.0 (2020-02-22)
* Update C code to use newer RTypedData API versus older RData API.
* Update C code to use rb_cObject versus the older, deprecated, rb_cData.
* Update memory management - CallInfo's now keep alive their owning Profile instances. Fixes crashes that
  could happen in rare instances.

## 1.2.0 (2020-01-23)
* Fix call stack printer broken in version 1.0.0 (Charlie Savage)
* Ruby 2.7.0 support (Charlie Savage)
* Switch to Windows high precision timer for measuring wall time (Charlie Savage)
* Much better support for reverse call trees - if you start RubyProf at the bottom
  of a call tree it will correctly calculate times as it ascends the tree (Charlie Savage)
* Port AggregateCallInfo from Ruby to C to increase performance
* API change - CallInfo has been renamed CallTree
* Fix crashes on Ruby 2.4.*

## 1.1.0 (2019-12-14)
Changes

* Reimplement merge_fibers (Charlie Savage)
* Fix crash caused by threads being freed when profiles are freed (Charlie Savage)

## 1.0.0 (2019-07-29)
ruby-prof's development stretches all the way back to 2005. Fourteen years later, it seems time for version 1.0!
Version 1.0 is a significant update that greatly improves the internals of ruby-prof and adds a number of improvements.

Changes (Charlie Savage):

* Profiling is significantly faster - 5x in some cases
* Recursive profiles are finally handled correctly.  Yeah!!!
* Redesigned reports (Chirs Whitefield)
* New documentation website (https://ruby-prof.github.io)
* The ability to measure allocations and memory usage using a standard (unpatched) version of ruby
* The ability to save and reload profiling results for later analysis
* The ability track object allocations

At the same time, it was also time to remove old code and deprecated methods. These changes include (Charlie Savage):

* Drop support for old versions of ruby. Currently 2.4 and up are required.
* Remove support for method elimination (instead use method exclusion).
* Remove the CPU_TIME measurement mode since it duplicates the PROCESS_TIME mode and required inline assembly code
* Remove the GC_TIME and GC_RUNS measurement modes since they required patched ruby versions. In modern ruby it is possible to reimplement this functionality, but it does not seem of that much value (shout out if you want it back).
* Merge the RubyProf::FlatPrinterWithLineNumbers printer into RubyProf::FlatPrinter.
* Removed support for RUBY_PROF_EDITOR_URI environment variable that specified the link scheme. This features was more confusing then helpful.


## 0.18.0 (2019-05-27)
### Fixes
* Fix grouping by thread/fiber (Charlie Savage)
* Fix include/exclude thread checking (Charlie Savage)
* Fix failing tests (Charlie Savage)
* Fix grouping by thread_id and fiber_id (Charlie Savage)
* Update Visual Studio solution to 2019 (Charlie Savage)
* Adjust AbstractPrinter#editor_uri so it's possible to disable uri (Maciek Dubiński)-
* Fix -X/--exclude-file option not working (John Lindgren)
* Different directory for middleware output in readme (Aldric Giacomoni)
* Fixing spelling mistakes and typos (David Kennedy and Roger Pack)
* Add "allow_exceptions" option to Profile (Ryan Duryea)
* Update readme (Jan Piotrowski, Nathan Seither, victor-am)
* Travis updates (Niocals Leger and Charlie Savage)
* Fix NewRelic module detection in exclude_common_methods! (Ben Hughes)

## 0.17.0 (2017-12-17)
* Changed method/class names produced by the callgrind printer to be more kcachegrind
  friendly (thx to Nelson Gauthier and Ben Hughes, see https://github.com/ruby-prof/ruby-prof/pull/200).
* Recursive instances of a method call are now dtected during profiling (thx to Nelson Gauthier and
  Ben Hughes, see https://github.com/ruby-prof/ruby-prof/pull/201).
* Methods can now be ignored during a profiling run instead of eliminating them
  after a profile run, which has been deprecated (thx to Nelson Gauthier and Ben Hughes,
  see https://github.com/ruby-prof/ruby-prof/pull/202).
* Use RUBY_PROF_EDITOR_URI=emacs to open source code links in the one true editor.
  (thx Alexander Egorov, see https://github.com/ruby-prof/ruby-prof/pull/183 and
  https://github.com/typester/emacs-handler).
* Fixed that calling profile.stop would stop profiling all active profiling runs.
* Fixed that remembering parent call frame pointer before stack reallocation could cause a segfault.

## 0.16.2 (2016-08-25)
* fixed incorrect setting of RUBY_VERSION macro

## 0.16.1 (2016-08-24)
* fixed compile problem with ruby 2.1.10

## 0.16.0 (2016-08-24)
* ruby-prof can now be installed if ruby has been compiled with --disable-gems or
  RUBYOPT includes --disable-gems (thx to Arthur Nogueira Neves)
* Profile.new now accepts and prefers an options hash:
  - measure_mode: one of the RubyProf measure mode constants
  - exclude_threads: an array of threads to ignore when collecting profile data
  - include_threads: an array of threads to include when collecting profile data
  - merge_fibers: whether or not to merge the profile data for all fibers under their creating thread
* overhauled printer for cachegrind profiles:
  - profile data for each thread dumped to a separate file, as kcachegrind does not
    fully implement the cachegrind specification
  - this required a change in interface: it's now necessary to specify a directory
    where to dump the cachegrind files
  - naming convention for cachegrind files changed so that kcachegrind shows them
    all in the open dialog
* improved Rack middleware:
  - it's now possible to use the MultiPrinter
  - new option ignore_existing_threads: will ignore all prexisiting threads
    when profiling a request, except the thread perfoming the request.
  - new option request_thread_only: will ignore all preexisting threads, but also
    all threads spwaned during the execution of the rack request.
  - new option merge_fibers: whether or not to merge the profile data for all fibers under their creating thread
* fixed setting threshold bug when displaying stack profiles (thx to Michal Konarski)
* code related to printing profiles is now autoloaded for efficiency (thx to Dave Gynn)

## 0.15.9 (2015-12-08)
* rack profiler now supports lambdas for generating profile paths (thx to Jean Rougé)
* fixed a bug when printing graph profiles

## 0.15.8 (2015-04-24)
* added missing assets to gem build
* fixed randomly failing test

## 0.15.7 (2015-04-23)
* html profiles are now single page (thx to Thomas Leishman)

## 0.15.6 (2015-02-22)
* improved upon computing children time in graph printers

## 0.15.5 (2015-02-22)
* changed output format of flat_printer_with_line_number
* support using multi printer from command line (Dov Murik)

## 0.15.4 (2015-02-14)
* using env variable to specify mesaurement mode work again
* measuring memory/object allocations works for 2.1 adn 2.2 again

## 0.15.3 (2015-01-16)
* support ruby 2.2.0

## 0.15.2 (2014-05-20)
* rack middleware creates print dir for profile result (Neng)

## 0.15.1 (2014-05-20)
* added license to gemspec

## 0.15.0 (2014-05-02)
* improved cpu time measurement (Charlie Somerville)

## 0.14.2 (2014-01-05)
* hopefully fixed compile problem under Windows

## 0.14.0 (2014-01-02)
* support ruby 2.1.0
* dropped support for 1.8.x, 1.9.1 and 1.9.2

## 0.13.1 (2013-12-14)
* speed up for displaying large call stacks (Benjamin Quoming)

## 0.13 (2013-03-10)
* support fibers on 1.9.x+
* improved display for very wide call stacks (Sammy Larbi)

## 0.12.2 (2013-02-13)
* Fixed segfault when using falcon or railsexpress patches for 1.9.3

## 0.12.1 (2013-01-07)
* Add back in pause/resume support since Rails uses it

## 0.12.0 (2013-01-06)
* Ruby 2.0.0 support (Charlie Savage)
* Fix issue where profiling results could exceed 100% if profile code had multiple top level methods (Charlie Savage)
* Replaced RubyProf::Thread#top_method with RubyProf::Thread#top_methods (Charlie Savage)
* Added RubyProf::Thread#total_time (Charlie Savage)
* Remove the -r and -e command line options.  If you need specific libraries or code profiled then add them
  to your code (Charlie Savage).
* Rewrite ruby-prof script to be more self-contained (Gary Weaver)
* Fix list formatting in readme (Thilo Rusche)
* Remove pause/resume support since its buggy and complicates the code

## 0.11.3 (2012-12-27)
* Prefix c functions with prof_ to avoid name conflicts (Kenta Murata)
* Update ruby-prof script to avoid seg faults (Gary Weaver)
* Rakefile updates (Roger Pack)
* Fix regexp file reading (Gilbert Roulot)
* Update documentation (Timo Schilling)
* Fix up ruby warnings (Mike Gehard)
* Remove duplicate code (Chas Lemley)


## 0.11.2 (2012-05-06)
* Fix compile issue with BOOL.  Should be _Bool for C99.


## 0.11.1 (2012-05-06)
* Added option --exclude-common-callbacks, plus exclude #map and #inject in common cycles (Vasily Fedoseyev)
* Add option --exclude-common-cycles to exclude common iterators (Vasily Fedoseyev)
* Allow method elimination from command line via '-x' and '-X' keys (Vasily Fedoseyev)


## 0.11.0 (2012-05-05)
* Fix pause/resume so it actually works and add tests (David Barri)
* Resume now returns the result of the block when given (David Barri)
* Make recursive method explanation more clear (Charlie Savage)
* Fix ruby warnings (Charlie Savage)
* Toggle GC.enable_stats when profiling for memory to get the data (Vasily Fedoseyev)
* Fix patched ruby support and remove some warnings (Vasily Fedoseyev)
* Fix tests on 1.8.7 (rogerdpack)


## 0.11.0.rc3 (2012-03-26)
* Include missing files in gemspec (Charlie Savage).


## 0.11.0.rc2 (2012-03-25)
* Lots of improvements to Rack handler - this can be used to profile requests
  in Rails and other rack-based ruby web frameworks (Charlie Savage).
* Reimplemented handling of recursive calls using CallInfoVisitor (Charlie Savage).
* Fix bug where child times were not correctly reported in complicated
  call graphs with recursion like in frameworks like Rails (Charlie Savage).
* Add in recursive call information to Flat, Graph and Graph HTML reports (Charlie Savage).
* Add in new thread class add added RubyProf::Thread#top_method to
  make report generation easier (Charlie Savage).
* Add in CallInfoVisitor class to make it easy to iterate over a call graph (Charlie Savage).
* Add in CallInfoPrinter to make it visualize RubyProf's internal call graphs (Charlie Savage).
* Significant updates to documentation (Charlie Savage).
* More c code cleanup (Charlie Savage).

## 0.11.0.rc1 (2012-03-24)
* Big internal refactoring of C code to make RubyProf easier to understand and extend (Charlie Savage).
* Profile results are now returned as instances of a new class RubyProf::Profile.  The old api
  is supported via a compatability layer that at some point will be deprecated.  (Charlie Savage).
* On Windows, use QueryPerformanceCounter and QueryPerformanceFrequency to measure CPU time instead
  of rdtsc.  This change is based on Microsoft's recommendation (Charlie Savage).
* On Windows use GetProcessTimes to return real PROCESS_TIME times instead of wall times (Charlie Savage).
* Split out tests for each time of measurement (cpu_time, process_time, etc.) (Charlie Savage).
* Dropped support for Ruby 1.8.4 and 1.8.6 and 1.9.0 (Charlie Savage).
* Added support for sorting results by total, self, wait and child times (Jan Suchal)
* Added tests for sorting behaviour & removed options from constructor to print method (Jan Suchal)
* Fix line number tests due to changes at top of file (Charlie Savage).
* Add encoding statement to top of all files for Ruby 1.9.x compatability (Charlie Savage).
* Add def file for VC to avoid the whole declspec annoyance (Charlie Savage).
* Update test suite to ensure current working directory is correct (Charlie Savage).
* Modernize gem file and remove various custom/home grown solutions that aren't needed anymore (Charlie Savage).
* Remove custom mingw build scripts, use rake compiler instead  (Charlie Savage).
* Fixes for compiling with VC 2010 (Charlie Savage).

## 0.10.8 (2011-07-06)
* 1.9.3 super class (Roger Pack)

## 0.10.7 (2011-05-09)
* Fix a bug with REE's GC stats. Issue #53 [thanks graaff]

## 0.10.6 (2011-04-29)
* Slightly more normalized url for linux/windows links to files.

## 0.10.5 (2011-04-20)
* 1.8.6 compat for -v command (bug fix)

## 0.10.4 (2011-04-20)
* Faster load time for ruby-prof itself.

## 0.10.3
* Can cleanly load before rubygems now.

## 0.10.2
* Fix for 1.9.2, os x for latest commits (thanks skaes!)

## 0.10.1
* Fix bug in linux wall time, also load with only relative paths so that you can use it to benchmark rubygems startup overhead,
  itself.

## 0.10.0
* Some rdoc changes, for linux wall time attempt to use higher granularity (thanks to all the contributors for this round!)

## 0.9.2
* Make graphviz work on 1.8.6
* Roll back some 1.9.2 optimizations until I can figure out what caused them.

## 0.9.1
* Add a graphviz output

## 0.9.0
* measurements for recursive methods are now correct
* gave up on splitting up recursive methods according to call depth
* made it possible to eliminate methods from profiling results
* new printer for call stack visualization
* new printer to print several profiles in one run
* HTML profiles contain Textmate links so you can jump to the source code easily
* producing an event log is now a runtime option

## 0.7.10 (2009-01-22)
* fix SEGFAULT in 1.9
* add new printer flat_printer_with_line_numbers

## 0.7.7 (2009-01-13)
* "fix" multi threading support for 1.9 http://redmine.ruby-lang.org/issues/show/2012
* speedups

## 0.7.6 (2009-12-31)
* fix some tests for 1.9 (no real code changes)

## 0.7.5 (2009-12)
* fix a GC collection bug (nobu's patch).
* correctly report recursive call depths (Kevin Scaldeferri).
* sort methods on output (Kevin Scaldeferri).

## 0.7.3 (2008-12-09)
* Fixed compile error with new x86_64 code using GCC.

## 0.7.2 (2008-12-08)
* Fixed major bug in printing child methods in graph reports.

* Fixes for supporting x86_64 machines (Diego Pettenò)


## 0.7.1 (2008-11-28)
* Added new AggregateCallTree class for printers to
  make results easier to read.  Take this call sequence
  for example:

   A   B   C
   |   |   |
   Z   A   A
       |   |
       Z   Z

  By default, ruby-prof will show that Z was called by 3 separate
  instances of A.  In an IDE that is helpful but in a text report
  it is not since it makes the report much harder to read.
  As a result, printers now aggregate together callers (and children),
  matching ruby-prof's output from versions prior to 0.7.0.

* Fixes for supporting x86_64 machines (Matt Sanford)


## 0.7.0 (2008-11-04)

### Features
* Added two new methods - RubyProf.resume and RubyProf.pause.
  RubyProf.resume takes an optional block, which ensures that
  RubyProf.pause is called.  For example:

  10.times do |i|
    RubyProf.resume do
      # Some long process
    end
  end

  result = RubyProf.stop

* Added support for profiling tests that use Ruby's built-in
  unit test framework (ie, test derived from
  Test::Unit::TestCase).  To enable profiling simply add
  the following line of code to your test class:

    include RubyProf::Test

  By default, profiling results are written to the current
  processes working directory.  To change this, or other
  profiling options, simply modify the PROFILE_OPTIONS hash
  table as needed.

* Used the new support for profiling test cases to revamp
  the way that Rails profiling works.  For more information
  please refer to RubyProf's documentation.

* Keep track of call stack for each method to enable more
  powerful profile visualizations in Integrated Development
  Environments (Hin Boean, work supported by CodeGear).

* Expose measurements to Ruby (Jeremy Kemper).

* Add support for additional memory measurements modes in Ruby 1.9 (Jeremy Kemper).

* Add support for Lloyd Hilaiel's Ruby patch for measuring total heap size.
   See http://lloydforge.org/projects/ruby. (Jeremy Kemper).


### Fixes
* RubyProf.profile no longer crashes if an exception is
  thrown during a profiling run.

* Measure memory in fractional kilobytes rather than rounding down (Jeremy Kemper)


## 0.6.0 (2008-02-03)

ruby-prof 0.6.0 adds support for Ruby 1.9 and memory profiling.

### Features
* Added support for ruby 1.9 (Shugo Maeda)
* Added support for outputting printer results to a String, Array or IO
  object (Michael Granger)
* Add new memory profiling mode.  Note this mode depends on a
  patched Ruby interpreter (Alexander Dymo)

### Fixes
* Improvements to GraphHtmlPrinter including updated documentation,
  fixes for min_time support, ability to specify templates using
  strings or filenames, and table layout fixes (Makoto Kuwata)
* Fixes to scaling factor for calltrees so that precision is not lost
  due to the conversion to doubles (Sylvain Joyeux)
* Changed constant ALLOCATED_OBJECTS to ALLOCATIONS in the C code to
  match the Ruby code (Sylvain Joyeux)
* Added support for calltree printer to ruby-prof binary script (Sylvain Joyeux)
* Fix support for the allocator measure mode to extconf.rb (Sylvain Joyeux)
* Honor measure mode when specified on the command line (Sylvain Joyeux)
* Sorting of methods by total time was incorrect (Dan Fitch, Charlie Savage)
* Fix ruby-prof to work with the latest version of GEMS (Alexander Dymo)
* Always define MEASURE_CPU_TIME and MEASURE_ALLOCATIONS in Ruby code, but
  set their values to nil if the functionality is not available.


## 0.5.2 (2007-07-19)

ruby-prof 0.5.2 is a bug fix release.

### Fixes
* Include missing rails plugin


## 0.5.1 (2007-07-18)

ruby-prof 0.5.1 is a bug fix and performance release.

### Performance
* Significantly reduced the number of thread lookups by
  caching the last executed thread.

### Fixes
* Properly escape method names in HTML reports
* Fix use of -m and --min-percent command line switches
* Default source file information to ruby_runtime#0 for c calls
* Moved rails_plugin to top level so it is more obvious
* Updated rails_plugin to write reports to the current
  Rails log directory
* Added additional tests


## 0.5.0 (2007-07-09)

### Features
* Added support for timing multi-threaded applications
* Added support for 64 bit systems (patch from Diego 'Flameeyes' Petten)
* Added suport for outputting data in the format used by
  KCacheGrind (patch from Carl Shimer)
* Add filename and line numbers to call tree information (patch from Carl Shimer)
* Added Visual Studio 2005 project file.
* Added replace-progname switch, als rcov.
* Added better support for recursive methods
* Added better support for profiling Rails applications

### Fixes
* Fixes bug when the type of an attached object (singleton) is inherited
  from T_OBJECT as opposed to being a T_OBJECT (identified by Francis Cianfrocca)
* ruby-prof now works in IRB.
* Fix sort order in reports.
* Fixed rdoc compile error.
* Fix tabs in erb template for graph html report on windows.

## 0.4.1 (2006-06-26)

### Features
* Added a RubyProf.running? method to indicate whether a profile is in progress.
* Added tgz and zip archives to release

### Fixes
* Duplicate method names are now allowed
* The documentation has been updated to show the correct API usage is RubyProf.stop not RubyProf.end


## 0.4.0 (2006-06-16)
### Features
* added support for call graphs
* added support for printers.  Currently there is a FlatPrinter,
  GraphPrinter and GraphHtmlPrinter.
* added support for recursive methods
* added Windows support
* now packaged as a RubyGem

### Fixes
* Fixes bug where RubyProf would crash depending on the
  way it was invoked - for example, it did not run when
  used with Arachno Ruby's customized version of Ruby.
